import { StyleSheet, Dimensions } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";

export const myReviresStyle = StyleSheet.create({
    container: {
        flex: 1,
        paddingHorizontal: dpr(20),
        backgroundColor: "#fff",
        paddingBottom: dpr(15),
    },
    detailsCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
    },
    detailsTitle: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(14),
        color: "#2C2C2C",
        marginTop: dpr(20),
        textAlign: 'left'
    },
    detailsText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(12),
        color: "#868686",
        marginTop: dpr(5),
        lineHeight: dpr(18),
        textAlign: 'left'
    },
    detailsImgCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
    },
    detailsImg: {
        marginTop: dpr(11),
        flexDirection: "row",
    },
    detailsSingleImg: {
        width: dpr(40),
        height: dpr(40),
        marginRight: dpr(8),
        borderRadius: dpr(2),
        position: "relative",
        backgroundColor: "white",
    },
    layerImg: {
        width: dpr(40),
        height: dpr(42),
        marginRight: dpr(8),
        backgroundColor: "rgba(255, 255, 255, 0.9)",
        display: "flex",
        justifyContent: "center",
        alignItems: "center",
        borderRadius: dpr(2),
        position: "absolute",
        right: 0,
        borderRadius: dpr(2),
    },
    layerImgText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(10),
        color: "#898989",
    },
    editReviewCont: {
        flexDirection: "row",
        alignItems: "center",
    },
    editText: {
        marginLeft: dpr(6),
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(12),
        color: "#898989",
    },
    dropDown: {
        height: dpr(20),
        width: dpr(50),
        flexDirection: "row",
        justifyContent: "flex-end",
        alignItems: "center",
    },
    flatList: {
        marginTop: dpr(20),
        flex: 1,
        backgroundColor: "#FFFFFF",
    }
});
